﻿/// <reference path="Default.aspx" />
function pageLoad()
{
    //global setting options for static proxy
    //ajaxbooksamples.com.product.set_defaultSucceededCallback(onSuccess);
    //ajaxbooksamples.com.product.set_defaultFailedCallback(onFailed);
}

function LookupProduct()
{
    var criteria = new ProductLookupDemo.SearchCriteria();
    criteria.ProductNumber = $get("productNumber").value;
    
    //staic calling method
    //ajaxbooksamples.com.product.Lookup($get("productNumber").value,onSuccess,onFailed);
    //ajaxbooksamples.com.product.AdvancedLookup(criteria,onSuccess,onFailed);
    
    //instance calling method
    var productService = new ajaxbooksamples.com.product();
    //productService.Lookup($get("productNumber").value,onSuccess,onFailed);
    productService.AdvancedLookup(criteria,onSuccess,onFailed);
    
}

function PageMethodLookupProduct()
{
    PageMethods.ProductLookup($get("productNumber").value,onSuccess,onFailed);
    
}

function onSuccess(result, userContext, methodName)
{
    $get("productDescription").value = result.Description;
    $get("productPrice").value = result.Price;
}

function onFailed(result, userContext, methodName)
{
    alert("An error occured \n"  + result.get_message());
}

function SerializeProductDetail()
{
    var productDetail = new ProductLookupDemo.ProductDetail();
    productDetail.ProductNumber = "200";
    productDetail.Description = "Czarny kontroler konsoli XBox";
    productDetail.Price = 50;
    
    var productDetailJSON = Sys.Serialization.JavaScriptSerializer.serialize(productDetail);
    
    Sys.Debug.trace(productDetailJSON);
    
    return productDetailJSON;
}

function CallServiceWithWebRequest()
{
    
    var searchCriteria = new ProductLookupDemo.SearchCriteria();
    searchCriteria.ProductNumber = $get("productNumber").value;

    var searchCriteriaJSON = Sys.Serialization.JavaScriptSerializer.serialize(searchCriteria);

    var request = new Sys.Net.WebRequest();
    request.get_headers()['Content-Type'] = 'application/json; charset=utf-8';
    request.set_url("Product.svc/AdvancedLookup");
    request.set_body("{\"criteria\":" + searchCriteriaJSON + "}");
    request.set_httpVerb("POST");
    request.add_completed(onCompleted);
    request.invoke();
}

function onCompleted(executor, eventArgs) 
{
    if (executor.get_responseAvailable()) 
    {
        var statusCode = executor.get_statusCode();
        var result = null;
        try 
        {
            result = executor.get_object();
        }
        catch (ex) {}

        var error = executor.getResponseHeader("jsonerror");
        var errorObj = (error === "true");
        if (errorObj) 
        {
            // wyświetla komunikat o błędzie
            var errorMessage = String.format("Wystąpił błąd z komunikatem o treści {0}, śladem stosu w postaci {1} oraz typem wyjątku {2}",result.Message, result.StackTrace, result.ExceptionType);
            alert(errorMessage);

        }
        if (((statusCode < 200) || (statusCode >= 300)) || errorObj) 
        {
            if (result && errorObj) 
            {
                // wyświetla komunikat o błędzie
                errorMessage = String.format("Wystąpił błąd typu {0} z komunikatem o treści {1}",result.get_exceptionType(), result.get_message());
                alert(errorMessage);
            }
            else 
            {
                // wyświetla komunikat o błędzie
                alert(executor.get_responseData());
            }
        }
        else 
        {
            
            // aktualizuje interfejs użytkownika
            $get("productDescription").value = result.d.Description;
            $get("productPrice").value = result.d.Price;
 
        }
    }
    else 
    {
        if (executor.get_timedOut()) 
        {
            // wyświetla komunikat o błędzie
            errorMessage = "Przekroczono limit czasowy żądania";
        }
        else if(executor.get_aborted()) 
        {
            errorMessage = "Przerwano przetwarzanie żądania";
        }
        else
        {
            // wyświetla komunikat o błędzie
            errorMessage = "Wystąpił błąd; nie zwrócono żadnych wyników";
        }
        
        alert(errorMessage);
    }
}
    
